#include <stdio.h>
#include "fdebug.h"
#include "3DSCLASS.h"

C3dsFile::~C3dsFile(){
	if (m_pHead)
		delete m_pHead;
}

// Function name	: C3dsFile::myread
// Description	    : 
// Return type		: bool 
// Argument         : void *buffer
// Argument         : DWORD size
bool C3dsFile::myread(void *buffer, DWORD size)
{
	memcpy(buffer, m_pCur, size);
	m_pCur += size;

	return true;
}


// Function name	: C3dsFile::mytell
// Description	    : 
// Return type		: DWORD 
DWORD C3dsFile::mytell()
{
	return m_pCur - m_pHead;
}


// Function name	: C3dsFile::myseek
// Description	    : 
// Return type		: bool 
// Argument         : int offset
// Argument         : int origin
bool C3dsFile::myseek(int offset, int origin)
{
	if (origin==SEEK_SET)
		m_pCur = m_pHead + offset;

	if (origin==SEEK_CUR)
		m_pCur += offset;

	if (origin==SEEK_END)
		m_pCur = m_pHead + m_Len + offset;
		
	return true;

}

// Function name	: C3dsFile::LoadFile
// Description	    : 
// Return type		: bool 
// Argument         : char *szFileName
bool C3dsFile::LoadFile(char *szFileName)
{
	FILE *file;

	if (szFileName==NULL)
	{
		FMSG("Null pointer");
		return false;
	}

	file = fopen(szFileName, "rb");
	if (file==NULL)
	{
		FMSG("File open error\n");
		return false;
	}

	fseek(file, 0, SEEK_END);
	m_Len = ftell(file);
	fseek(file, 0, SEEK_SET);

	m_pHead = m_pCur = (char*)malloc(m_Len);
	if (m_pHead == NULL)
	{
		FMSG("malloc error\n");
		return false;
	}

	if (fread(m_pHead, m_Len, 1, file)==0)
	{
		FMSG("File read error\n");
		return false;
	}

	fclose(file);

	return true;
}


// Function name	: C3dsFile::GetChunkId
// Description	    : 
// Return type		: bool 
// Argument         : unsigned short *pId
// Argument         : DWORD *pChkEnd
bool C3dsFile::GetChunkId(unsigned short *pId, DWORD *pChkEnd)
{
	DWORD Here;

	// verify the pointer
	if (pId==NULL)
	{
		FMSG("Null pointer\n");
		return false;
	}

	// are we at the end of the father-chunk
	Here = mytell();
	if (Here >= *pChkEnd)
	{
		return false;
	}

	memcpy(pId, m_pCur, 2);

	return true;
}


// Function name	: C3dsFile::WalkNext
// Description	    : 
// Return type		: bool 
// Argument         : DWORD *pChunk
bool C3dsFile::WalkNext(DWORD *pChunk)
{
	DWORD len;
	size_t nRead;
	DWORD Here;

	Here = mytell();
	if (Here >= *pChunk)
	{
		return false;
	}

	// skip chunk id
	if (myseek(2, SEEK_CUR)==false)
	{
		FMSG("");
		return false;
	}
	// read len
	nRead = myread(&len, 4);

	// the chunk lenght is "len". but we already read 6 bytes. so lets
	// jump over len-6 bytes
	if (myseek((int)len-6, SEEK_CUR)==false)
	{
		FMSG("");
		return false;
	}

	return true;
}


// Function name	: C3dsFile::WalkInto
// Description	    : 
// Return type		: bool 
// Argument         : CPtrList *pList
// Argument         : DWORD *pChunkEnd
bool C3dsFile::WalkInto(DWORD *pChunkEnd)
{
	DWORD Here;
	unsigned short Id;
	DWORD Len;
	DWORD nRead;
	
	Here = mytell();
	if (Here >= *pChunkEnd)
	{
		FMSG("");
		return false;
	}

	// jump over chunk Id

	Here = mytell();
	// read the Id to compute the chunk datas
	myread(&Id, 2);

	Here = mytell();

	// read the len of the chunk, so the children will know
	// the end of their father
	nRead = myread(&Len, 4);

	Here = mytell();

	// Update len of chunk we want to go into
	*pChunkEnd = Here + Len - 6;
	printf("Walk into; Len = %d\n", Len);
	
	// We have to skip treat data of the chunk we are to go into
	switch(Id)
	{
	CASE(4d4d);
	CASE(3d3d);
	CASE(4000);
	CASE(4100);
	CASE(4110);
	CASE(4120);
	CASE(4140);
	CASE(B000);
	CASE(B008);
	CASE(B020);	
	default:
		FMSG_HEXA("WalkInto: Unknown chunk Id = ", Id);
		return false;
	}

	return true;
}



// Function name	: C3dsFile::Process
// Description	    : 
// Return type		: bool 
bool C3dsFile::Process()
{
	return Process(&m_Len);
}


// Function name	: C3dsFile::Process
// Description	    : 
// Return type		: bool 
// Argument         : DWORD *pChkEnd
bool C3dsFile::Process(DWORD *pChkEnd)
{
	ID Id;

	for(;;)
	{
		DWORD OldPos;
		DWORD ThisChkEnd;
	
		ThisChkEnd = *pChkEnd;

		if (GetChunkId(&Id, pChkEnd)==false)
		{
			return false;
		}

		printf("id=%x\n", Id);

		OldPos = mytell();

		if (WalkInto(&ThisChkEnd)==true)
		{
			Process(&ThisChkEnd);
		}

		myseek(OldPos, SEEK_SET);

		if (WalkNext(pChkEnd)==false)
		{
			break;
		}
	}

	return true;
}

// Parameters: CPtrList *pList

IMPLEMENT_CASE(4d4d){

	return true;
}

IMPLEMENT_CASE(3d3d){

	return true;
}

IMPLEMENT_CASE(4000){
	char ObjName[80];
	DWORD Cpt1 = 0;
	DWORD Here;
	CObj3d *pObj; // The new object

	Here = mytell();
	do{
		myread(&ObjName[Cpt1], 1);
	}while(ObjName[Cpt1++] != '\0');
	printf("#### Object: %s at %x\n", &ObjName[0], Here);

	pObj = new CObj3d();

	m_List.AddHead(pObj);

	return true;
}

IMPLEMENT_CASE(4100){

	return true;
}

// Coord
IMPLEMENT_CASE(4110){

	WORD NbVertices;
	DWORD Cpt1;
	CObj3d *pObj;
	VERTEX *pVertices;

	if (m_List.IsEmpty())
	{
		FMSG("List is empty");
		return false;
	}
	pObj = (CObj3d*)m_List.GetHead();

	myread(&NbVertices, 2);
	pVertices = pObj->AllocVertices(NbVertices);

	printf("This object has %d vertices\n", NbVertices);

	for(Cpt1=0;Cpt1<NbVertices;Cpt1++)
	{
		myread(&pVertices[Cpt1].x, 4);
		myread(&pVertices[Cpt1].y, 4);
		myread(&pVertices[Cpt1].z, 4);
		/*printf("\t%d> %f, %f, %f\n", Cpt1, pObj->pVertices[Cpt1].x,
			pObj->pVertices[Cpt1].y, pObj->pVertices[Cpt1].z);*/
	}

	return true;
}

// Faces
IMPLEMENT_CASE(4120){

	DWORD Cpt1;
	WORD NbFaces;
	WORD A,B,C,Flag;
	CObj3d *pObj;
	FACE *pFaces;

	if (m_List.IsEmpty())
	{
		FMSG("List is empty");
		return false;
	}
	pObj = (CObj3d*)m_List.GetHead();

	myread(&NbFaces, 2);
	pFaces = pObj->AllocFaces(NbFaces);
	printf("This object has %d faces\n", NbFaces);

	for(Cpt1=0;Cpt1<NbFaces;Cpt1++)
	{
		myread(&A, 2);
		myread(&B, 2);
		myread(&C, 2);
		myread(&Flag, 2);
		pFaces[Cpt1].A = A;
		pFaces[Cpt1].B = B;
		pFaces[Cpt1].C = C;
		//printf("\t%d> %d, %d, %d\n", Cpt1, A,B,C);
	}


	return true;
}

// Mapping
IMPLEMENT_CASE(4140){

	WORD NbVertices;
	DWORD Cpt1;
	float sow,tow;
	CObj3d *pObj;
	VERTEX *pVertices;

	if (m_List.IsEmpty())
	{
		FMSG("List is empty");
		return false;
	}
	pObj = (CObj3d*)m_List.GetHead();

	myread(&NbVertices, 2);
	pVertices = pObj->AllocVertices(NbVertices);
	printf("This object has %d mapped vertices\n", NbVertices);

	pObj->SetMapping();

	for(Cpt1=0;Cpt1<NbVertices;Cpt1++)
	{
		myread(&sow, 4);
		myread(&tow, 4);
		pVertices[Cpt1].sow = sow*256;
		pVertices[Cpt1].tow = tow*256;
		//printf("\t%d> %f, %f\n", Cpt1, sow,tow);
	}

	return true;
}

// Keyframer
IMPLEMENT_CASE(B000){
	return true;
}

// Keyframer : Frames
IMPLEMENT_CASE(B008){
	DWORD dwStart, dwEnd;

	myread(&dwStart, 4);
	myread(&dwEnd, 4);
	fprintf(stderr, "%d %d\n", dwStart, dwEnd);
	return true;
}

IMPLEMENT_CASE(B020){
	float x,y,z;

	myread(&x, 4);
	myread(&y, 4);
	myread(&z, 4);

	printf("%f %f %f\n", x,y,z);
	return true;
}

// Function name	: C3dsFile::GetList
// Description	    : 
// Return type		: CObj3d* 
CObList* C3dsFile::GetList()
{
	return &m_List;
}


// Function name	: C3dsFile::RemoveEmptyObjects
// Description	    : 
// Return type		: void 
void C3dsFile::RemoveEmptyObjects()
{
	POSITION pos1, pos2;
	CObj3d *pObj;
	
	pos1 = m_List.GetHeadPosition();
	while((pos2 = pos1) != NULL)
	{
		pObj = (CObj3d*)m_List.GetNext(pos1);
		if (pObj==NULL)
		{
			m_List.RemoveAt(pos2);
			continue;
		}
		else
		{
			if (pObj->GetNbVertices()==0)
			{
				m_List.RemoveAt(pos2);
				delete pObj;
				continue;
			}
		}
	}
}

bool C3dsFile::GetMinMax(VECTOR * pMin, VECTOR * pMax)
{
	VECTOR MinTmp, MaxTmp;
	CObj3d *pObj;

	if ((pMin==NULL)||(pMax==NULL))
		return false;

	POSITION pos = m_List.GetHeadPosition();
	if (pos==NULL)
		return false;

	// We have to initialize pMin and pMax
	pObj = (CObj3d*)m_List.GetNext(pos);
	pObj->GetMinMax(pMin, pMax);

	while(pos)
	{
		pObj = (CObj3d*)m_List.GetNext(pos);
		if (pObj==NULL)
			continue;
		if (pObj->GetMinMax(&MinTmp, &MaxTmp)==false)
			continue;
		if (MinTmp.x < pMin->x)
			pMin->x = MinTmp.x;
		if (MinTmp.y < pMin->y)
			pMin->y = MinTmp.y;
		if (MinTmp.z < pMin->z)
			pMin->z = MinTmp.z;

		if (MaxTmp.x > pMax->x)
			pMax->x = MaxTmp.x;
		if (MaxTmp.y > pMax->y)
			pMax->y = MaxTmp.y;
		if (MaxTmp.z > pMax->z)
			pMax->z = MaxTmp.z;
	}


	return true;
}

void C3dsFile::Translate(VECTOR * pTrans)
{
	CObj3d *pObj;
	
	if (pTrans==NULL)
		return;

	POSITION pos = m_List.GetHeadPosition();

	while(pos)
	{
		pObj = (CObj3d*)m_List.GetNext(pos);
		if (pObj==NULL)
			continue;

		pObj->Translate(pTrans);
	}
}

void C3dsFile::Center()
{
	VECTOR Min, Max, Trans;

	if (GetMinMax(&Min, &Max)==false)
		return;

	Trans.x = -(Min.x + Max.x)/2;
	Trans.y = -(Min.y + Max.y)/2;
	Trans.z = -(Min.z + Max.z)/2;

	Translate(&Trans);
}

bool C3dsFile::Export(char * szBaseName)
{
	CObj3d *pObj;
	DWORD Cpt1 = 0;
	char szFileName[_MAX_PATH];
	int Count;

	if (szBaseName==NULL)
		return false;

	Count = m_List.GetCount();
	POSITION pos = m_List.GetHeadPosition();

	while(pos)
	{
		if (Count==1)
			sprintf(szFileName, "%s", szBaseName, Cpt1);
		else
			sprintf(szFileName, "%s%.3d", szBaseName, Cpt1);
		pObj = (CObj3d*)m_List.GetNext(pos);
		if (pObj)
			pObj->Export(szFileName);
		Cpt1++;
	}

	return true;
}

